<?php require_once __DIR__  . '/auth-ini.php';

$disabled = !empty(uss::$global['options']->get('user:disable-signup'));

if( !$disabled ):

	$auth_container(function( $auth_url ) { ?>

		<div class="signup-wrapper">
			<div class="form-wrapper">
				
				<?php events::exec('?dashboard:signup-form::above'); ?>
				
				<form method='post' action="<?php echo dashboard::config('auth_url') ?? $auth_url; ?>" id='auth-form' data-type='signup' enctype='multipart/form-data'>
					<div class="row py-3">
						<div class="col-sm-10 col-md-9 m-auto">
							
							<?php
								$collect = !empty( uss::$global['options']->get( "user:collect-username" ) );
								if( $collect ) {
									events::addListener('?dashboard:signup-input', function() { ?>
									<div class="mb-3">
										<input type="text" placeholder="Username" class='form-control' name='username' required pattern="^\s*\w+\s*$">
									</div>
							<?php }, 0);
								};
							?>
							
							<?php 
								events::addListener('?dashboard:signup-input', function() { ?>
									<div class="mb-3">
										<input type="email" placeholder="Email" class='form-control' name='email' required>
									</div>
								<?php }, 1);
							?>
							
							<?php 
								events::addListener('?dashboard:signup-input', function() { ?>
									<!-- end col -->
									<div class="mb-3">
										<input type="password" placeholder="Password" class='form-control' name='password' required pattern='^.{4,}$'>
									</div>
								<?php }, 2);
							?>
							
							<?php 
								events::addListener('?dashboard:signup-input', function() { ?>
									<!-- end col -->
									<div class="mb-4">
										<input type="password" placeholder="Confirm Password" class='form-control' name='confirm_password' pattern='^.{4,}$' required>
									</div>
								<?php }, 3);
							?>
								
							<?php 
								events::addListener('?dashboard:signup-input', function() { ?>
									<!-- end col -->
									<div class='mb-4'>
										<div class="form-check user-select-none">
											<input class="form-check-input" type="checkbox" value="" id="tos" required>
											<label class="form-check-label" for="tos">
												<small>
													I agree to the <a href='<?php echo dashboard::config('tos-page') ?? 'javascript:void(0)'; ?>'>Terms Of Service</a> &amp; <a href='<?php echo dashboard::config('privacy-page') ?? 'javascript:void(0)'; ?>'>Privacy Policy</a>
												</small>
											</label>
										</div>
									</div>
								<?php }, 4);
							?>
							
							<?php
								events::addListener('?dashboard:signup-input', function() { ?>
									<!-- end col -->
									<div class="button-group d-flex justify-content-center flex-wrap">
										<button class="btn btn-primary w-100" type='submit'>
											Sign Up
										</button>
									</div>
								<?php }, 5);
							?>
							
							<?php events::exec('?dashboard:signup-input', [], true); // assending UID; ?>
							
							
						</div>
					</div>
				<!-- end row -->
				</form>
				
				<?php 
					events::addListener('?dashboard:signup-form::below', function() { ?>
						<div class='mt-4'>
							<p class="text-sm text-medium text-dark text-center">
								Already have an account? 
								<a href="<?php echo dashboard::config('location'); ?>" class='text-nowrap'>
									Sign In
								</a>
							</p>
						</div>
					<?php }, 0);
				?>
				
				<?php events::exec('?dashboard:signup-form::below'); ?>
						
			</div>
		</div>

	<?php }, '--auth-signup');

else:

?>

	<div class='vh-100 bg-light d-flex align-items-center justify-content-center text-center auth-bg-image'>
		<div class='vh-100 vw-100 bg-dark bg-opacity-75 position-absolute'></div>
		<div class='position-relative'>
			<h3 class='text-white display-3 p-4'>
				<span class='d-block border-bottom pb-3 mb-2'> Sorry! </span> Signup is not available
			</h3>	
		</div>
	</div>

<?php endif; 