<?php require_once __DIR__ . '/auth-ini.php';

$auth_container(function( $auth_url ) { ?>

	<div class="signin-wrapper">
		<div class="form-wrapper">
			
			<?php events::exec('?dashboard:signin-form::above'); ?>
			
			<form method='post'action="<?php echo dashboard::config('auth_url') ?? $auth_url; ?>" id='auth-form' data-type='signin' enctype='multipart/form-data'>
				<div class="row py-3">
					<div class="col-sm-10 col-md-9 m-auto">
						
						<?php events::addListener('?dashboard:signin-input', function() { ?>
							<div class="mb-3">
								<input type="text" placeholder="Login detail" class='form-control' name='login' required pattern="^\s*(?:\w+|(?:[^@]+@[a-zA-Z0-9\-_]+\.\w{2,}))\s*$">
							</div>
						<?php }, 1); ?>
							
						<?php events::addListener('?dashboard:signin-input', function() { ?>
							<div class="mb-4">
								<input type="password" placeholder="Password" class='form-control' name='password' required pattern='^.{4,}$'>
							</div>
						<?php }, 2); ?>
							
						<?php events::addListener('?dashboard:signin-input', function() { ?>
							<div class='d-flex justify-content-between mb-3'>
								<div class="form-check user-select-none">
									<input type='hidden' name='remember' value='0'>
									<input class="form-check-input" type="checkbox" name='remember' value="1" id="checkbox-remember">
									<label class="form-check-label" for="checkbox-remember">
										<small>Remember me</small>
									</label>
								</div>
								<div class='resend-email'>
									<a href='javascript:void(0)' title="Resend Confirmation Email" data-vcode>
										<i class='mdi mdi-email-check'></i>
									</a>
								</div>
							</div>
						<?php }, 3); ?>
													
						<?php events::addListener('?dashboard:signin-input', function() { ?>
							<div class="">
								<button class="btn btn-primary w-100" type='submit'>
									Sign In
								</button>
							</div>
						<?php }, 4); ?>
							
						<?php events::exec('?dashboard:signin-input', [], true); ?>
						
					</div>
				</div>
				<!-- end row -->
			</form>
			
			<?php 
				events::addListener('?dashboard:signin-form::below', function() { 
					$disabled = !empty(uss::$global['options']->get('user:disable-signup'));
					if( $disabled ) return;
			?>
				<div class="mt-2">
					<p class="text-sm text-center">
						Don’t have an account yet? 
						<a href="<?php echo dashboard::config('location') . "/signup" ?>" class='text-nowrap'>
							Create an account
						</a>
					</p>
				</div>
			<?php }, 0); ?>
			
			<?php events::addListener('?dashboard:signin-form::below', function() { ?>
				<div class="mt-2">
					<p class="text-sm text-center">
						Forgot Password? 
						<a href="<?php echo dashboard::config('location') . "/reset"; ?>" class="hover-underline text-nowrap">
							Reset Password
						</a>
					</p>
				</div>
			<?php }, 1); ?>
				
			<?php events::exec('?dashboard:signin-form::below'); ?>
			
		</div>
	</div>

<?php }, '--auth-signin');