<?php 

dashboard::config( 'location', core::url( ROOT_DIR . "/" . DASHBOARD_FOCUS_URI ) );

$auth_container = function(callable $func, $class) { 
	
	$auth_url = core::url( DASHBOARD_MOD_DIR . '/ajax/auth.php' );
	
?>

		<div class="row g-0 auth-row <?php echo $class; ?>">

			<!-- col -->
			<div class="col-lg-6">
				<div class="auth-cover-wrapper bg-primary-100">
					<div class="auth-cover">
						<div class="title text-center">
							<div class='mb-2'>
								<img src='<?php echo uss::$global['icon']; ?>' class='img-fluid user-select-none'>
							</div>
							<?php events::addListener('?auth:text', function() { ?>
								<h1 class="text-white mb-10">
									<?php echo uss::$global['title']; ?>
								</h1>
								<p class="text-light">
									<?php echo uss::$global['tagline']; ?>
								</p>
							<?php }, 0); ?>
							<?php events::exec('?auth:text', array('section' => $class)); ?>
						</div>
					</div>
				</div>
			</div>
			<!-- end col -->
			
			<!-- col -->
			<div class="col-lg-6">
				<?php $func( $auth_url ); ?>
			</div>
	
<?php };