<?php 

uss::focus( dashboard::config('page:notification'), function() {
	
	/*
		dashboard::ready is not necessary here!
		However, we need it to confirm the authentication status applied to the dashboard before displaying output
	*/

	require __DIR__ . '/SECTIONS/notification-query.php';
		
	dashboard::view(function() use($notify) { ?>
		
		<div class='container-fluid'>
			<div class='row'>
				<div class='col-md-10 col-lg-9 m-auto'>
				
					<?php 
						events::addListener(':notifications::above', function() use($notify) { 
							if( !$notify['query']->num_rows ) return;
					?>
						<div class='text-end mb-2'>
							<a href='javascript:void(0)' data-nx-action='mark-all' class='btn btn-sm btn-outline-success'>
								Mark all as read
							</a>
						</div>
					<?php }); ?>
					
					<?php events::exec(':notifications::above'); ?>
					
					<div class='card mb-4' data-parse='nx' id='notification-list'>
															
						<?php 
							
							if( $notify['query']->num_rows ):
							
								while( $notification = $notify['query']->fetch_assoc() ):
									
									$image = $notification['image'];
									
									if( empty($image) ) $image = dashboard::call('user:avatar', $notification['origin']);
									
									$markdown = call_user_func(function() use($notification) {
										$message = str_replace(
											['<', '>'],
											['&lt;', '&gt;'],
											trim( $notification['message'] )
										);
										return (new Parsedown())->text( $message );
									});
									
									$redirect = $notification['redirect'] ?? 'javascript:void(0)';
									
									$viewed = empty($notification['viewed']) ? 'unviewed' : null;
						?>
						
						<div class="single-notification p-3">
							
							<a href='<?php echo $redirect; ?>' class='notification-redirect <?php echo $viewed; ?>' data-nx='<?php echo $notification['id']; ?>'></a>
							
							<div class="notification">
								<div class="image ">
									<img src='<?php echo $image; ?>' class=''>
								</div>
								<div class="content">
									<div class='notification-wrapper text-sm text-gray'>
										<?php echo $markdown; ?>
									</div>
									<span class="text-sm text-medium text-gray">
										<?php echo core::elapse( $notification['period'] ); ?> 
										<?php if( !empty($notification['redirect']) ): ?>
											<i class='mdi mdi-vector-link ms-1'></i>
										<?php endif; ?>
									</span>
								</div>
							</div>

							<div class="action">
							
								<button class="more-btn dropdown-toggle" id="moreAction" data-bs-toggle="dropdown" aria-expanded="false">
									<i class="lni lni-more-alt"></i>
								</button>
								
								<ul class="dropdown-menu dropdown-menu-end" aria-labelledby="moreAction">
									
									<?php events::exec(':notification-action'); ?>
									
									<li class="dropdown-item">
										<a href="javascript:void(0)" class="text-gray text-sm d-block" data-nx-action='remove'>
											<i class='mdi mdi-trash-can-outline me-1'></i> Remove
										</a>
									</li>
									
								</ul>
								
							</div>
						  
						</div>
						
						<?php 
								endwhile; 
								
							else:
						
						?>
						
							<div class='text-center py-5'>
								<div class='px-md-5'>
									
									<div class='row'>
										<div class='col-sm-8 m-auto col-lg-6'>
											<img src='<?php echo core::url( DASHBOARD_MOD_DIR . '/assets/images/UFO-search.gif' ); ?>' class='img-fluid'>
										</div>
									</div>
									
									<h2 class='text-capitalize fw-light'>No Notifications <br> to display</h2>
								
								</div>
							</div>
							
						<?php endif; ?>
							
					</div>
		
					<?php
						events::addListener(':notifications::below', function() use($notify) {
							
							if( empty($notify['next']) && empty($notify['prev']) ) return;
							
							$i = 0;
							
							if( $notify['next'] ) $i++;
							if( $notify['prev'] ) $i++;
							
							$col = 12 / $i;
							
							$query = $_GET;
							unset( $query['query'] );
							
					?>
						<div class='row'>
						
							<?php if( $notify['next'] ): ?>
								<div class='col-sm-<?php echo $col; ?>'>
									<a href='?<?php echo http_build_query( array_merge($query, array('view' => $notify['next']) )); ?>' class='btn btn-warning w-100 text-sm'>
										<i class='mdi mdi-arrow-collapse-left'></i> Older
									</a>
								</div>
							<?php endif; ?>
							
							<?php if( $notify['prev'] ): ?>
								<div class='col-sm-<?php echo $col; ?>'>
									<a href='?<?php echo http_build_query( array_merge($query, array('view' => $notify['prev'])) ); ?>' class='btn btn-success w-100 text-sm'>
										Newer <i class='mdi mdi-arrow-collapse-right'></i> 
									</a>
								</div>
							<?php endif; ?>
							
						</div>
					<?php }); ?>
					
					<?php events::exec(':notifications::below'); ?>
					
				</div>
			</div>
		</div>
		
	<?php });

});