<?php 

defined( 'DASHBOARD_MOD_DIR' ) OR DIE;

/*
	- Create the dashboard menu outside a focus path!
	
	- This is because if it is created inside a focus path, it will only be accessible in that focused URL
	
	- Hence, users cannot browse the menu outside that path
*/

uss::$global['menu']->add('dashboard', array(
	'label' => "Dashboard",
	"icon" => "<i class='lni lni-grid-alt'></i>",
	'href' => core::url( ROOT_DIR . "/" . DASHBOARD_FOCUS_URI ),
	'active' => $_GET['query'] == DASHBOARD_FOCUS_URI
));


// Focus Path;

uss::focus( DASHBOARD_FOCUS_URI, function() {
	
	require DASHBOARD_MOD_DIR . "/view/AUTH/verify-email.php";
	
	dashboard::view(function() {
		
		/*
			- The index page is empty
			
			- A module needs to fill it up by adding an event listener;
		*/
		
		events::exec('dashboard.index::content');
		
	});
	
});