<?php 

defined( 'DASHBOARD_MOD_DIR' ) OR DIE;

if( !empty(uss::$global['options']->get('user:affiliation')) ) {
	
	uss::$global['menu']->get('prospect')->add('team-tree', array(
		'label' => "Hierarchy",
		'href' => core::url( ROOT_DIR . "/" . ($FOCUS = DASHBOARD_FOCUS_URI . "/account/hierarchy") )
	))->set_attr( 'active', $_GET['query'] === $FOCUS );
	
	uss::focus( $FOCUS . "(?:/?\w+)?", function() use($FOCUS) {
		
		events::addListener('@head::after', function() {
			$dir = core::url( DASHBOARD_MOD_DIR . "/assets/vendor/datatree" );
			echo "\t<link rel='stylesheet' href='{$dir}/treeNode.css'/>\n";
		});
		
		events::addListener('@body::after', function() use($FOCUS) {
			$dir = core::url( DASHBOARD_MOD_DIR . "/assets/vendor/datatree" );
			echo "\t<script src='{$dir}/treeData.js'></script>\n";
			require_once __DIR__ . '/SECTIONS/treedata.php';
		});
		
		dashboard::view(function() { ?>
			<div class='container-fluid'>
				<div class='tree-container position-relative rounded-2'>
					<div id='hierarchy' class='overflow-auto'></div>
				</div>
			</div>
		<?php });
		
	});
	
};