<?php 

defined( 'DASHBOARD_MOD_DIR' ) OR DIE;

if( !empty(uss::$global['options']->get('user:affiliation')) ) {
	
	uss::$global['menu']->get('prospect')->add('team', array(
		"label" => "My Team",
		"href" => core::url( ROOT_DIR . "/" . ( $FOCUS = DASHBOARD_FOCUS_URI . "/account/team" ) )
	))->set_attr( 'active', $_GET['query'] == $FOCUS );
	
	// Now the interface;
	
	uss::focus( $FOCUS, function() { 
		
		dashboard::view(function() { 
			
			$userid = uss::$global['user']['id'];
			
			$hierarchy = new hierarchy();
			
			$result = $hierarchy->descendants_of( $userid );
			
			$table = new DOMTablet( 'affiliates' );
			$table->data( $result );
			
			$columns = array(
				'mail' => 'email',
				'usercode' => 'referral code',
				'register_time' => 'registered',
				'depth' => 'level'
			);
			
			if( uss::$global['options']->get('user:collect-username') ) array_unshift($columns, 'username');
			
			$table->columns($columns);
			
			$table->wrap('container-fluid');
			
			$table->prepare(function($data) {
				$data['mail'] = "<a href='mailto:{$data['email']}'>{$data['email']}</a>";
				return $data;
			}, true);
		
		});
		
	});

};