<?php 

defined( "DASHBOARD_MOD_DIR" ) OR DIE;

uss::$global['menu'] = new menufy();
uss::$global['user'] = null;


/*
	Let's setup some default configurations shall we!
*/

$__vars = array(

	'user:disable-signup' => 0,
	
	'user:collect-username' => 0,
	
	'user:confirm-email' => 0,
	
	'user:lock-email' => 0,
	
	'user:reconfirm-email' => 1,
	
	'user:default-role' => 'member',
	
	'user:affiliation' => 0,
	
	'user:auto-trash-unverified-after-day' => 7,
	
	'email:admin' => 'info@' . $_SERVER['SERVER_NAME'],
	
	'smtp:state' => 'default'
	
);

foreach( $__vars as $key => $value ) {
	$data = uss::$global['options']->get($key);
	if( is_null($data) ) uss::$global['options']->set( $key, $value );
}


/*
	Hey! There was once a "REMEMBER ME" authentication login code here!
	
	- The remember me authentication process was removed!
	- Though secured! A "remember me" identifier is valid for days and this long validity period poses security risk
	- The process was removed not based on lower security measures but for a different module to handle it instead
	- Hence, a module focused that purpose will perform better at security than one aiming to handle too many request!

*/

/*
	Authenticate user Login
*/

if( isset($_SESSION['access_token']) ) {
	
	/*
		Don't know why the access_token is being sanitized!
		But just gotta sanitize it anyway!
	*/
	
	$_SESSION['access_token'] = uss::$global['mysqli']->real_escape_string( $_SESSION['access_token'] );
	
	$prefix = DB_TABLE_PREFIX;
	
	$SQL = "
		SELECT * FROM {$prefix}_users
		WHERE SHA2(CONCAT(usercode, id),256) = '{$_SESSION['access_token']}'
	";
	
	$user = uss::$global['mysqli']->query( $SQL )->fetch_assoc();
	
	uss::$global['user'] = $user;
	
};


/*
	Update Some `uss::$global` Variables
*/

dashboard::call('site:__vars');


/*
	Check if affiliation is turned ON!
	Then — Capture Referral Code
*/

if( uss::$global['options']->get('user:affiliation') ) {
	
	/*
		The get sponsor secret method call be used in any page!
		Let's assume you create a custom referral link like:
		
		https://domain.com?upline=ref-link
		
		Then you can easily capture the referral link using
		
		dashboard::call( 'user:get-sponsor', 'upline' );
	*/
	
	dashboard::call('user:get-sponsor');
	
};

