<?php 

( defined( 'ADMIN_MOD_DIR' ) && $_SERVER['REQUEST_METHOD'] == 'POST' ) OR DIE;

$template = require DASHBOARD_MOD_DIR . "/view/MAIL/template.php";

$TITLE = uss::$global['title'];

if( roles::user( $userid )::hasPermission( 'view-cpanel' ) ) {
	$HREF = core::url( ROOT_DIR . '/' . ADMIN_FOCUS_URI );
} else {
	$HREF = core::url( ROOT_DIR . '/' . DASHBOARD_FOCUS_URI );
};

$message = "
	<x2:html>
		<x2:head>
			<x2:style>
				.list { 
					margin: 12px; 
				}
				p { 
					padding: 5px; 
				}
				.mb {
					margin-bottom: 12px;
				}
				li { 
					margin: 5px 0 
				}
			</x2:style>
		</x2:head>
		<x2:body>
			<x2:h2>Your account has been created!</x2:h2>
			<x2:hr/>
			<x2:p>Hello</x2:p>
			<x2:p>
				A new account has been created for you on {$TITLE}. <x2:br/>
				Use the credential below for your first login
			</x2:p>
			<x2:ul class='list'>
				<li>Login: {$_POST['user']['email']}</li>
				<li>Password: {$USER_PASSWORD}</li>
			</x2:ul>
			<x2:p class='mb'>
				Use the link below to login and reset your password! <x2:br/>
				<x2:a href='{$HREF}'>{$HREF}</x2:a>
			</x2:p>
			<x2:h4>Regards</x2:h4>
		</x2:body>
	</x2:html>
";

$X2Client = new X2Client( $message );
$message = $X2Client->render( "body > table");


$__body = core::replace_var( $template, array(
	'content' => $message,
	'footer' => "Thank you for joining {$TITLE}"
));


$PHPMailer = dashboard::call( 'PHPMailer' );
$PHPMailer->Subject = "New Account Created";
$PHPMailer->Body = $__body;
$PHPMailer->addAddress( $_POST['user']['email'] );


if( $PHPMailer->send() ) {
	
	$message = "<i class='bi bi-check-circle me-1'></i> User was successfully notified by email";
	$type = 'success';
	
} else {
	
	$message = "<i class='bi bi-x-circle me-1'></i> User could not be notified by email";
	$type = 'error';
	
};


events::addListener( 'admin.user-new-form::above', function() use($message, $type) {
	echo "
		<div class='alert alert-{$type} text-sm'>
			{$message}
		</div>
	";
});