<?php 

//! Define a menu title incase you need to update it!

$menu_title = 'resource';


//! Create Parent Menu!

uss::$global['menu']->add( $menu_title, array(
	'label' => 'tools',
	'icon' => "<i class='lni lni-target'></i>",
	'active' => (uss::query(0) == ADMIN_FOCUS_URI && in_array(uss::query(1), ['settings', 'info']))
));


//! Attach Child Menu!

uss::$global['menu']->get( $menu_title )->add('info', array(
	'label' => 'info',
	'href' => core::url( ROOT_DIR . '/' . ( $FOCUS = ADMIN_FOCUS_URI . '/info' ) )
));


// Declare a focus path;

uss::focus( $FOCUS, function() use($menu_title) {
	
	//! 
	
	uss::$global['menu']->get( $menu_title )->get('info')->set_attr('active', true);
	
	//!
	
	dashboard::view(function() {
		
		// Prepare Information;
		
		$info = array();
		
		$info['installation Directory'] = ROOT_DIR;
		$info['Domain Name'] = $_SERVER['SERVER_NAME'];
		$info['HTTPS'] = ( $_SERVER['SERVER_PORT'] == 80 ) ? 'Disabled' : 'Enabled';
		$info['IP Address'] = $_SERVER['REMOTE_ADDR'];
		$info['Website URL'] = core::url( ROOT_DIR );
		$info['Admin Email'] = uss::$global['options']->get('email:admin');
		
		$time = new DateTime();
		$timezone = $time->getTimezone();
		$location = $timezone->getLocation();
		
		$info['Date Time'] = $time->format('Y-m-d H:i:s');
		$info['TimeZone'] = $timezone->getName();
		$info['Country Code'] = $location['country_code'];
		$info['Latitude'] = $location['latitude'];
		$info['Longitude'] = $location['longitude'];
		
		$info['Server Software'] = $_SERVER['SERVER_SOFTWARE'];
		$info['PHP OS'] = PHP_OS;
		$info['PHP Version'] = PHP_VERSION;
		$info['MYSQLI Version'] = uss::$global['mysqli']->server_info;
		
		$info['Database Host'] = DB_HOST;
		$info['Database Username'] = DB_USER;
		$info['Database Password'] = '****'; //DB_PASSWORD;
		$info['Database Name'] = DB_NAME;
		$info['Database Table Prefix'] = DB_TABLE_PREFIX;
		
		$info['Platform Name'] = PROJECT_NAME;
		$info['Platform Version'] = '2.0.0';
		$info['Platform Prefix'] = 'USS';
		$info['Platform Language'] = 'en-GB';
		$info['Platform Documentation'] = "<a class='text-nowrap' href='https://digitalwebplus.com/cbt-source-code/' target='_blank'>
			<i class='bi bi-link-45deg me-1'></i> View Documentation
		</a>";
		
		$info['Author'] = 'DigitalWeb Plus';
		$info['Author Name'] = 'DigitalWeb Plus';
		
		$info['Author Website'] = "<a href='https://digitalwebplus.com/' class='text-uppercase text-nowrap' target='_blank'>
			<i class='bi bi-globe-americas me-1'></i> DigitalWeb Plus
		</a>";
		
		$info['Author Github'] = "<a href='#' target='_blank' class='text-uppercase text-nowrap'>
			<i class='fab fa-github me-1'></i> 
		</a>";
		
		
		
		// Prepare Table;
		
		$table = new DOMTablet( 'info' );
		$table->chunk(100);
		$table->columns(['key', 'value']);
		
		$data = array();
		
		foreach( $info as $key => $value ) 
			$data[] = array( 'key' => $key, 'value' => $value );
		
		
		// Set Table Data;
		
		$table->data( $data );
		
		
		// Style Table;
		
		$table->wrap('rounded-1');
		
		$table->doc->getElementsByTagName('thead')->item(0)->setAttribute( 'class', 'd-none' );
		$table->table->setAttribute( 'class', $table->table->getAttribute('class') . " table-striped" );
		
	?>
		
		<div class='container-fluid'>
			<div class='row'>
				
				<div class='col-lg-12'>
					<?php $table->prepare(null, true); ?>
				</div>
				
			</div>
		</div>
		
	<?php });
	
});