<?php 

defined( 'ADMIN_MOD_DIR' ) OR DIE;


//! Add to users settings

require __DIR__ . '/settings.php';


/*
	Implement Support Ticket Based On Settings!
*/

	
events::addListener('admin::ready', function() {
	
	
	//! Helpdesk Configuration!

	$enabled = uss::$global['options']->get( 'helpdesk:enabled' );

	if( is_null($enabled) ) $enabled = uss::$global['options']->set( 'helpdesk:enabled', 1 );
	

	if( $enabled ) {
		
		
		require __DIR__ . '/utils/scan.php';
		
		
		/*
			;-o HMM...
			And why does the above file look like:
			import util.scanner - Java Package
		*/
		
		
		/*
			Now we have to divide the section!
			-----------------------------------
			- Support Ticket Channel for Members &
			- Support Ticket Panel for Admin
		*/ 
		
		if( uss::query(0) === ADMIN_FOCUS_URI ) {
			
			require __DIR__ . '/backend/index.php';
			
		} else if( uss::query(0) === DASHBOARD_FOCUS_URI ) {
			
			require __DIR__ . '/frontend/index.php';
			
		};
		
	
	} else {
		
		$__A = DASHBOARD_FOCUS_URI . "/support/?(chat/)?(?:\w+)?";
		$__B = ADMIN_FOCUS_URI . "/ticket/?(?:\w+)?";
		
		uss::focus( "(?:(?:{$__A})|(?:{$__B}))", function() {
			
			dashboard::config('sidebar', false);
			
			dashboard::view(function() {
				$href = core::url( ROOT_DIR . '/' . ( uss::query(0) == 'admin' ? ADMIN_FOCUS_URI : DASHBOARD_FOCUS_URI ) );
				echo "
					<div class='border py-5 bg-light mx-3'>
						<div class='display-3 text-center py-5 container'>
						
							<div class='row'>
								<div class='col-lg-5 mx-auto'>
								
									<div class='fw-semibold'>Not Available</div>
									<p class='text-muted'>Sorry! You cannot access this feature</p>
									<div class='my-4'>
										<a class='btn btn-lg btn-outline-info w-100' href='{$href}'>
											Visit Homepage
										</a>
									</div>
									
								</div>
							</div>
							
						</div>
					</div>
				";
			});
			
		});
		
	};

}, EVENT_FLOAT );


