<?php 

defined( 'ADMIN_MOD_DIR' ) OR DIE;

uss::$global['menu']->get('users')->add('new', array(
	'label' => 'Add new',
	'href' => core::url( ROOT_DIR . '/' . ADMIN_FOCUS_URI . '/users/new' )
));

uss::focus( ADMIN_FOCUS_URI . '/users/new', function() {
	
	require ADMIN_MOD_DIR . '/pages/POST/user-new.php';
	
	dashboard::view(function() { 
	
		$getPost = function($group, $key) {
			if( !empty(uss::$global['status']) || empty($_POST[$group]) ) return;
			return $_POST[$group][$key] ?? null;
		};
	
	?>
	
		<div class='container-fluid'>
		
			<div class='border-bottom pb-2 mb-3'>
				<h3> <i class='mdi mdi-account-plus me-1'></i> Add New User</h3>
			</div>
				
			<?php
				events::addListener('admin/users/new@form::above', function() { 
			?>
				<div class='col-md-12 mb-4'>
					<div class='alert alert-dark text-sm'>
						<span class='text-capitalize'>Default registration role is &mdash; <strong class='text-primary'><?php echo uss::$global['options']->get('user:default-role'); ?></strong></span>. <br> You can change this in user settings
					</div>
				</div>
			<?php }, EVENT_FLOAT ); ?>
			
			<?php events::exec( 'admin/users/new@form::above' ); ?>
			
			<form method='post' enctype='multipart/form-data'>
				<fieldset>
				
					<div class='row'>
						
						<div class='col-md-8 mb-4'>
							
							
							<div class='row mb-3'>
								<label class='col-lg-3 form-label'>Username</label>
								<div class='col-lg-9'>
									<input type='text' class='form-control' name='user[username]' placeholder='&mdash; unique' value='<?php echo $getPost('user', 'username'); ?>'>
								</div>
							</div>
						
							<div class='row mb-3'>
								<label class='col-lg-3 form-label --required'>Email</label>
								<div class='col-lg-9'>
									<input type='email' class='form-control' name='user[email]' placeholder='example &nbsp; &mdash; &nbsp; user@email.com' required value='<?php echo $getPost('user', 'email'); ?>'>
								</div>
							</div>
						
							<div class='row mb-4'>
								<label class='col-lg-3 form-label --required'>Password</label>
								<div class='col-lg-9'>
									<input type='text' class='form-control' name='user[password]' placeholder='****' required>
								</div>
							</div>
						
							<div class='row mb-3'>
								<div class='col-lg-9 ms-auto'>
									<div class='form-check form-switch toggle-switch'>
										<input type='checkbox' class='form-check-input' name='alert' value='1'>
										<label class='form-check-label'><big>Notify user by email</big></label>
									</div>
								</div>
							</div>
							
							<?php events::exec('admin/users/new@form:col-left'); ?>
							
						</div>
						
						<div class='col-md-4 mb-4'>
							
							<div class='text-center'>
								<div class='user-avatar mx-auto mb-2'>
									<img src='<?php echo core::url( DASHBOARD_MOD_DIR . '/assets/images/user.png' ); ?>' class='img-fluid' id='image'>
								</div>
								<input type='file' name='avatar' accept='.jpg, .gif, .png, .jpeg, .webp' class='d-none' id='file' data-uss-image-preview='#image'>
								<button class='btn btn-outline-primary' type='button' data-uss-trigger-click='#file'>Add Avatar</button>
							</div>
							
							<?php events::exec('admin/users/new@form:col-right'); ?>
							
						</div>
						
						<?php events::exec('admin/users/new@form:col'); ?>
						
						<input type='hidden' name='nonce' value='<?php echo uss::nonce( 'user-new' ); ?>'>
						
						<div class='border-top py-3 mt-2'>
							<button class='btn btn-primary'>
								<i class='mdi mdi-account-plus me-1'></i> Add User
							</button>
						</div>
						
					</div>
			
				</fieldset>
			</form>
				
		</div>
	
	<?php });
	
});