<?php 

defined( 'ADMIN_MOD_DIR' ) OR DIE;

if( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
	
	if( $_POST['nonce'] !== uss::nonce( 'users' ) ) 
		uss::console( ':alert', "Security Check Failed!" );
	
	else {
		
		
		// ----- [{ Create Post Event }] -------
		
		events::addListener( 'admin/settings/users::post', function() {
			
			$progress = [];
			
			foreach( $_POST['user'] as $key => $value ) 
				$progress[] = uss::$global['options']->set( "user:{$key}", $value );
			
			uss::$global['status'] = $status = !in_array( false, $progress );
			
			if( $status ) {
				uss::$global['message'] = "<i class='fas fa-check-circle text-success'></i> Changes were saved";
			} else {
				uss::$global['message'] = "<i class='fas fa-times text-danger'></i> Changes were not saved!";
			};
			
			uss::console( ':alert', uss::$global['message'] );
		
		}, EVENT_FLOAT ); // [{ End Post Event }];
		
		
		// -------- [{ Exec Event }] -------
		
		events::exec( 'admin/settings/users::post', [], true );
		
	}
	
};