<?php 

defined( 'ADMIN_MOD_DIR' ) or DIE;

if( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
	
	if( $_POST['nonce'] === uss::nonce( 'general' ) ) {
	
	
		$file = dashboard::call( 'upload_image', $_FILES['icon'], "general" );
		if( $file ) $_POST['site']['icon'] = $file;
		
		
		// ------- [{ Create Post Event }] --------
		
		events::addListener( 'admin/settings/general::post', function() {
			
			$progress = [];
			
			foreach( $_POST['site'] as $key => $value ) {
				$name = "site:{$key}";
				$progress[] = uss::$global['options']->set( $name, $value );
			};
			
			uss::$global['status'] = $status = !in_array(false, $progress);
			
			if( $status ) uss::$global['message'] = "<i class='fas fa-check-circle text-success me-1'></i> Changes were saved";
			else uss::$global['message'] = "<i class='fas fa-times text-danger me-1'></i> Changes were not saved";
			
			uss::console( ':alert', uss::$global['message'] );
		
		}, EVENT_FLOAT ); // [{ End Post Event }]
		
		
		// ---------- [{ Exec Event }] ----------
		
		events::exec( 'admin/settings/general::post', [], true );
		
		
		dashboard::call('site:reset-vars');
		
		
	} else uss::console( ':alert', "Security check failed!" );
	
};
