<?php 

/* 
	- Auto delete fake registrations 
	- As well as users who fail to activate their account
*/

call_user_func(function() {
	
	$trash_day = (int)uss::$global['options']->get('user:auto-trash-unverified-after-day');
	
	if( empty($trash_day) ) return;
	
	$prefix = DB_TABLE_PREFIX;
	
	$SQL = "
		SELECT {$prefix}_users.* FROM {$prefix}_users
		INNER JOIN {$prefix}_usermeta
			ON {$prefix}_users.id = {$prefix}_usermeta._ref
		WHERE 
			{$prefix}_usermeta._key = 'v-code'
			AND ( UNIX_TIMESTAMP() - {$prefix}_usermeta.epoch ) > ( 60 * 60 * 24 * {$trash_day} )
	";
	
	$results = uss::$global['mysqli']->query( $SQL );
	
	if( !$results->num_rows ) return;
	
	while( $user = $results->fetch_assoc() ) dashboard::call( 'user:delete', $user['id'] );
	
});


/*
	Add a new role ( administrator )
	----------------------------------
	- Since the `super-admin` priority number is 100
	- Then, administrator should be in a lower priority of 99
*/

$admin_permissions = array(
	'view-cpanel',
	'manage-users',
	'manage-ticket'
);

roles::add( 'administrator', 99, $admin_permissions );


// Enhance Super Admin Role;

roles::setPermission( 'super-admin', 'manage-ticket' );

