"use strict";

$(function() {
	
	// check at least on access control;
	
	let checkbox = $(".user-form-content [data-priv]");
	checkbox.on('change', function() {
		checkbox.prop( 'required', !checkbox.is(':checked') );
	});
	checkbox.prop( 'required', !checkbox.is(':checked') );
	
	// delete user account;
	
	$("#delete-account").click(function() {
		
		let self = this;
		
		bootbox.confirm({
			message: `
				<div class='fs-0_9rem'>
					<div class='mb-2'>You're about to take a serious action here! </div> 
					<div class='mb-2'>Deleting this account will remove everything pertaining to the user </div>
					<div> It is important to note that the action can never be reversed!</div>
				</div>
			`,
			title: "<i class='bi bi-exclamation-circle me-1'></i> Wait a minute",
			callback: function(ans) {
				if( !ans ) return;
				Notiflix.Loading.hourglass( 'Deleting Account' );
				$.ajax({
					url: uss._ajax2 + '/remove-user.php',
					data: {
						userid: self.dataset.user,
						nonce: uss._nonce
					},
					method: 'post',
					success: function(response) {
						Notiflix.Loading.remove();
						try {
							let result = JSON.parse(response);
							bootbox.alert({
								className: 'text-center',
								message: result.message,
								closeButton: false,
								centerVertical: true,
								size: 'small',
								callback: function() {
									if( result.status ) {
										Notiflix.Loading.circle();
										window.location.href = './';
									};
								}
							});
						} catch(e) {
							console.log( e );
							bootbox.alert({
								closeButton: false,
								size: 'small',
								message: "The server response could not be handled",
								className: 'text-center',
								centerVertical: true
							});
						}
					}
				});
			},
			buttons: {
				confirm: { 
					label: 'Delete',
					className: 'btn-danger'
				}
			}
		});
		
	});
	
});

