<?php 

roles::remove('member');

// Add new role;

roles::add('student', 4, array( 'access-portal'));

dashboard::config( '403-redirect', core::url( ROOT_DIR ) );


uss::focus('signout', function() {
	session_destroy();
	header( "location: " . core::url( ROOT_DIR ) );
	exit;
});


## --------

$empty = !uss::$global['mysqli']->query( sQuery::select( "{$prefix}_users" ) )->num_rows;

if( $empty ) {
	
	$data = array(
		'email' => 'superadmin@domain.com',
		'password' => password_hash( '123456', PASSWORD_DEFAULT ),
		'usercode' => core::keygen(6)
	);
	
	$SQL = sQuery::insert( "{$prefix}_users", $data );
	
	uss::$global['mysqli']->query( $SQL );
	
	roles::user( uss::$global['mysqli']->insert_id )::assign('super-admin');
	
};


## ----- remove unrequired resources ------

uss::$global['options']->set( 'helpdesk:enabled', 0 );

events::addListener('admin.settings::index', null, 'users');

events::addListener(':focused', function($data) {
	switch( $data['focus'] ) {
		case ADMIN_FOCUS_URI . '/settings/users':
			$data['callable'] = null;
		break;
	};
});


# ------ remove unrequired data -------

events::addListener( 'admin.settings.general-form::input', function() { 
	$diff = array();
	foreach( DateTimeZone::listIdentifiers( DateTimeZone::ALL ) as $value ):
		$currentTimeInZone = new \DateTime("now", new \DateTimeZone($value));
		$currentTimeDiff = $currentTimeInZone->format('P');
		if( array_key_exists($currentTimeDiff, $diff) ) continue;
		if( explode(':', $currentTimeDiff)[1] != '00' ) continue;
		$diff[ $currentTimeDiff ] = $value;
	endforeach;
?>	
	<div class='mb-4 mb-lg-5 row'>
		<label class='form-label col-lg-3'>Timezone GMT</label>
		<div class='col-lg-9'>
			<select class='form-select' name='site[timezone]' value='<?php echo uss::$global['options']->get('site:timezone'); ?>'>
				<?php 
					ksort($diff);
					foreach( $diff as $gmt => $value ):
				?>
				<option value='<?php echo $value; ?>'><?php echo "GMT ($gmt)"; ?></option>
				<?php endforeach; ?>
			</select>
		</div>
	</div>
<?php });

