<?php 

class cbt {

	public static function timer( $time ) {
		$time = explode( ".", $time );
		$timer = array(
			"hour" => self::digit( $time[0] ),
			"minute" => self::digit( $time[1] ?? 0 ),
			"second" => self::digit( $time[2] ?? 0 )
		);
		return $timer;
	}
	
	private static function digit( int $num ) {
		$num = round( $num );
		if( strlen($num) === 1 ) $num = "0{$num}";
		return (string)$num;
	}
	
	public static function getClientPortal( int $id, int $userid ) {
		
		$prefix = DB_TABLE_PREFIX;
		
		$SQL = "
			SELECT
			
				{$prefix}_portals.id,
				{$prefix}_portals.userid,
				{$prefix}_portals.period,
				{$prefix}_portals.complete,
					{$prefix}_exams.name,
					{$prefix}_exams.exam_time,
					{$prefix}_exams.start_date,
					{$prefix}_exams.instruction,
					{$prefix}_exams.status,
					{$prefix}_exams.portal,
						{$prefix}_solutions.epoch
					
			FROM {$prefix}_portals
			INNER JOIN {$prefix}_exams
				ON {$prefix}_portals.portal_id = {$prefix}_exams.portal
				
			LEFT JOIN {$prefix}_solutions
				ON {$prefix}_portals.id = {$prefix}_solutions.portal_id
				
			WHERE {$prefix}_portals.id = {$id}
				AND {$prefix}_portals.userid = {$userid}
			
			ORDER BY {$prefix}_solutions.epoch ASC 
			
			LIMIT 1
			
		";
		
		$result = uss::$global['mysqli']->query( $SQL );
		
		return $result->fetch_assoc();
		
	}
	
	public static function getScores( int $id, int $userid ) {
		
		$prefix = DB_TABLE_PREFIX;
		
		$SQL = "
			SELECT
				
				{$prefix}_portals.portal_id AS portal,
					{$prefix}_subjects.name AS subject,
						ROUND( IFNULL( SUM( {$prefix}_solutions.points ), 0 ), 1 ) AS points
			
			FROM {$prefix}_portals
			
			INNER JOIN {$prefix}_exams
				ON {$prefix}_portals.portal_id = {$prefix}_exams.portal
				
			LEFT JOIN {$prefix}_questions
				ON {$prefix}_questions.exam_id = {$prefix}_exams.id
				
			LEFT JOIN (
			
				SELECT 
					{$prefix}_solutions.*,
						{$prefix}_questions.points
				FROM {$prefix}_solutions
				INNER JOIN {$prefix}_questions
					ON {$prefix}_solutions.question_id = {$prefix}_questions.id
				WHERE {$prefix}_solutions.answer = {$prefix}_questions.correct
				
			) AS {$prefix}_solutions
				ON (	
					{$prefix}_solutions.question_id = {$prefix}_questions.id
					AND {$prefix}_solutions.portal_id = {$prefix}_portals.id
				)
				
			INNER JOIN {$prefix}_subjects
				ON {$prefix}_subjects.id = {$prefix}_questions.subject_id
				
			WHERE {$prefix}_portals.id = {$id}
				AND {$prefix}_portals.userid = {$userid}
				
			GROUP BY {$prefix}_questions.subject_id
			ORDER BY {$prefix}_subjects.name
		";
		
		$result = uss::$global['mysqli']->query( $SQL );
		
		$scores = array( 
			'score' => 0, 
			'id' => $id,
			'results' => array() 
		);
		
		while( $data = $result->fetch_assoc() ) {
			$scores['results'][] = $data;
			$scores['score'] += (float)$data['points'];
		};
		
		$scores['grade'] = self::getGrade( $id, $scores['score'] );
		
		return $scores;
		
	}
	
	public static function getGrade( string $id, float $score ) {
		$prefix = DB_TABLE_PREFIX;
		$portal = dashboard::fetch_assoc( "{$prefix}_portals", $id );
		$SQL = "
			SELECT 
				SUM( {$prefix}_questions.points ) as points
			FROM {$prefix}_questions
			INNER JOIN {$prefix}_exams	
				ON {$prefix}_questions.exam_id = {$prefix}_exams.id
			WHERE {$prefix}_exams.portal = '{$portal['portal_id']}'
		";
		$result = uss::$global['mysqli']->query( $SQL );
		if( !$result->num_rows ) return;
		$points = round($result->fetch_assoc()['points'], 1);
		$percent = round(( $score * 100 ) / $points, 1);
		$data = array(
			'percent' => $percent,
			'points' => $points,
			'name' => null,
			'type' => null
		);
		$SQL = sQuery::select( "{$prefix}_grades", "
			{$percent} >= _from AND {$percent} <= _to
		");
		$result = uss::$global['mysqli']->query( $SQL )->fetch_assoc();
		if( $result ) {
			$data['name'] = $result['_name'];
			$data['type'] = $result['_type'];
		};
		return $data;
	}
	
}