<?php 

events::addListener('@body::after', function() {
	$src = core::url( __DIR__  . "/download.js" );
	echo "\t<script src='{$src}'></script>\n";
});

// -----------------------

$prefix = DB_TABLE_PREFIX;

$user = uss::$global['user'];

$exam = cbt::getClientPortal( $_SESSION['portal'], uss::$global['user']['id'] );

uss::console( 'QURL', core::url( __DIR__ . '/ajax' ) );

uss::view(function() use($exam, $user) { 
	
	$timezone = uss::$global['options']->get('site:timezone') ?? 'Africa/Lagos';
	$timezone = new DateTimeZone($timezone);
	
	$start = new dateTime($exam['start_date'], $timezone);
	$now = new dateTime('now', $timezone);
	$ready = !($start > $now);
	
	
?>
	
	<div class='container-fluid bg-light py-5'>
		
		<div class='row'>
			<div class='col-lg-11 mx-auto'>
			
				<div class='row'>
					
					<div class='col-md-8 mb-4' id='frame'>
					
						<div class='card rounded-2 shadow-sm mb-4'>
						
							<h5 class='card-header py-4'>
								<?php echo $exam['name']; ?>
							</h5>
							
							<div class='card-body'>
								
								<?php if( empty($exam['complete']) ): ?>
								
									<div id='questions'>
									
										<?php if( $ready ): ?>
										
										<div class=''>
											
											<?php if( !empty($exam['instruction']) ): ?>
											
											<div class=''>
												<h6 class='text-info text-uppercase mb-3'>
													<u>Instruction</u>
												</h6>
												<?php echo $exam['instruction']; ?>
											</div>
											
											<hr>
											
											<?php endif; ?>
											
											<div class='text-center'>
												<button class='btn btn-success px-4 ' id='start'>
													Start Exam
												</button>
											</div>
										
										</div>
										
										<?php else: ?>
										
										<div class='display-5 text-center py-2'>
										
											<div class='py-4 mb-4 border-bottom'> Examination will start on </div>
											
											<div class='mb-4 fw-semibold'>
												<div class='mb-3'><?php echo $start->format('dS M, Y'); ?></div>
												<div class=''><?php echo $start->format('h:i A'); ?></div>
											</div>
											
											<div class='px-3 px-sm-5 mb-5'>
												<a href='<?php echo core::url( ROOT_DIR . '/signout'); ?>' class='btn btn-danger btn-lg w-100'>
													Exit Portal
												</a>
											</div>
											
										</div>
										
										<?php endif; ?>
									
									</div>
								
								<?php else: ?>
								
									<div class='table-responsive mb-b' id='result'>
										<table class='table table-bordered table-striped'>
											<thead>
												<tr>
													<th>Subject</th>
													<th>Score</th>
												</tr>
											</thead>
											<tbody data-tbody>
											</tbody>
										</table>
									</div>
									
									<div class='text-center lead'>
										TOTAL SCORE: <span class='fw-semibold' data-score></span>
										<hr>
										<div class='display-6 fw-semibold'>
											<p data-percent></p>
											<span data-grade></span>
										</div>
									</div>
									
								<?php endif; ?>
								
							</div>
						</div>
						
						<?php if( $ready ): ?>							
							<div class=''>
								<div class='' data-exit>
									<a href='<?php echo core::url( ROOT_DIR . '/signout'); ?>' <?php if( empty($exam['complete']) ): ?> data-uss-confirm='Are you sure you want to exit this portal <br> This will not change the quality or time of your examination' <?php endif; ?> class='btn btn-danger w-100'>
										Exit Portal
									</a>
								</div>
							</div>
						<?php endif; ?>
					
					</div>
					
					<div class='col-md-4'>
						<div class='card position-sticky' style='top:8px;'>
							<div class='card-body text-center'>
							
								<div class='fw-semibold py-2 mb-3 rounded-3 user-select-none'>
									<h4>Time Remaining</h4>
									<p class='px-4 mb-0 text-danger lead display-6 fs-1_5rem'>
										<span data-timer='hour'>00</span> :
										<span data-timer='minute'>00</span> :
										<span data-timer='second'>00</span>
									</p>
								</div>
								
								<hr>
								
								<h3 class='fw-normal'>
									<?php 
										$bio = uss::$global['usermeta']->get('user:bio', $user['id']); 
										echo "{$bio['firstname']} {$bio['lastname']}";
									?>
								</h3>
								
								<div class='mb-2 py-1 px-3'>
									<img src='<?php echo dashboard::call('user:avatar', $user['id']); ?>' class='img-fluid' width='300px'>
								</div>
								
								
							</div>
						</div>
					</div>
					
				</div>
			
			</div>
		</div>
		
	</div>
	
<?php });