<?php 

// Set HREF Location;

$LOCATION =  PANEL_URI . '/exams/new';

// Set Page Menu;

uss::$global['menu']->get('exam')->add('exam', array(
	'label' => 'Add new',
	'href' => core::url( ROOT_DIR . "/{$LOCATION}" ),
	'icon' => '<i class="bi bi-bar-chart"></i>',
	'active' => $_GET['query'] == $LOCATION
));

// Create Page Exams;

uss::focus( $LOCATION, function() {
	
	$prefix = DB_TABLE_PREFIX;
	
	if( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
		
		$responses = [
			"success" => "The exam has been %s. <br> <a href='%s'>return to the list</a>",
			"error" => "An error occured! <br> The exam could not be %s"
		];
		
		if( empty($_POST['id']) ) {
			
			$_POST['userid'] = uss::$global['user']['id'];
			$_POST['portal'] = mt_rand();
			
			$SQL = sQuery::insert( "{$prefix}_exams", $_POST, uss::$global['mysqli'] );
			
			$effect = 'created';
			
		} else {
			
			$SQL = sQuery::update( "{$prefix}_exams", $_POST, "id = '{$_POST['id']}'", uss::$global['mysqli'] );
			
			$effect = 'updated';
			
		};
		
		$status = uss::$global['mysqli']->query( $SQL ) ? "success" : "danger";
		
		$message = "<div class='alert text-center alert-{$status} mb-3'>{$responses[$status]}</div>";
		$message = sprintf( $message, $effect, core::url( ROOT_DIR . '/' . PANEL_URI . '/exams' ) );
		
	} else $message = null;
	
	
	$exam = dashboard::fetch_assoc( "{$prefix}_exams", $_GET['id'] ?? 0 );
	
	if( !$exam ) $exam = [];
	
	dashboard::view(function() use($message, $exam) { ?>
	
		<div class='container-fluid'>
			<div class='row'>
				
				<div class='col-lg-8 col-md-8 mb-3 m-auto my-2'>
					
					<div class='card'>
						<div class='card-body'>
							
							<form method='POST'>
								<div class='p-3 row'>
								
									<?php echo $message ?? null ?>
									
									<div class='col-lg-12 mb-3'>
									
										<input type='hidden' name='id' value='<?php echo $exam['id'] ?? null; ?>'>
										
										<div class='mb-4'>
											<label class='form-label'>Title</label>
											<input type='text' class='form-control form-control-lg' name='name' value='<?php echo $exam['name'] ??null; ?>' placeholder='Diploma Exam' required>
										</div>
										
										<div class='mb-4'>
											<label class='form-label'>Department</label>
											<?php
												$prefix = DB_TABLE_PREFIX;
												$SQL = sQuery::select( "{$prefix}_departments", "1 ORDER BY name ASC" );
												$departments = uss::$global['mysqli']->query( $SQL );
											?>
											<?php if( !$departments->num_rows ): ?>
												<div class='alert alert-warning text-center'>
													Please <a href='../departments'>Add Departments</a> to proceed!
												</div>	
											<?php endif; ?>
											<select class='form-control form-control-lg text-capitalize' name='department_id' required>
												<option value=''>-- Select --</option>
												<?php 
													if( $departments->num_rows ) {
														while( $department = $departments->fetch_assoc() ): 
															$selected = ($department['id'] == ($exam['department_id'] ?? null)) ? 'selected' : null;
												?>
												<option value='<?php echo $department['id']; ?>' <?php echo $selected; ?>>
													<?php echo $department['name']; ?>
												</option>
												<?php 
														endwhile;
													};
												?>
											</select>
										</div>
										
										<div class='mb-4'>
											<label class='form-label'> 
												Start Date <br> 
												<span class='text-muted text-sm text-nowrap'>Month / Day / Year</span> 
												<span class='text-muted text-sm text-nowrap'>Hour : Minute [AM/PM]</span>
											</label>
											<input type='datetime-local' class='form-control form-control-lg' name='start_date' placeholder='' required value='<?php echo $exam['start_date'] ?? null; ?>'>
										</div>
										
										<div class='mb-4'>
											<label class='form-label'>Timer</label>
											<input type='number' step='0.01' class='form-control form-control-lg' name='exam_time' placeholder='1.30 = ( 1 hr 30 min )' required value='<?php echo $exam['exam_time'] ?? null; ?>'>
										</div>
										
									</div>
									
									<div class='col-lg-12 mb-4'>
										<label class='form-label'>Instruction</label>
										<textarea name='instruction' class='form-control' placeholder='Before writing this exam, please read the questions carefully &hellip;' data-uss-editor='snow' rows='8'><?php echo $exam['instruction'] ?? null; ?></textarea>
									</div>
									
									<div class='col-lg-12 mb-4'>
										<div class='form-check form-switch toggle-switch'>
											<input type='hidden' name='status' value='0'>
											<input type='checkbox' class='form-check-input' name='status' <?php if( !empty($exam['status']) ) echo 'checked'; ?> value='1' id='--'>
											<label class='form-check-label' for='--'><big class='text-muted'>Active</big></label>
										</div>
									</div>
									
									<div class='col-lg-12'>
										<button type='submit' class='btn btn-primary btn-lg w-100'>
											<?php echo empty($exam) ? "Create" : 'Update'; ?> Exam
										</button>										
									</div>
									
								</div>
							</form>
							
						</div>
					</div>
					
				</div>
				
			</div>
		</div>
	
	<?php });
	
});