<?php 

// Set HREF Location;

$LOCATION =  PANEL_URI . '/exams/manager';

// Create Page Exams;

uss::focus( $LOCATION, function() {
	
	$prefix = DB_TABLE_PREFIX;
	
	$exam = dashboard::fetch_assoc( "{$prefix}_exams", $_GET['id'] ?? 0 );
	
	if( $exam ) {
		
		if( isset($_GET['delete']) ) {
			$question = dashboard::fetch_assoc( "{$prefix}_questions", $_GET['delete'] );
			if( $question && $question['exam_id'] == $exam['id'] ) {
				$SQL = "DELETE FROM {$prefix}_questions WHERE id = {$question['id']}";
				$deleted = uss::$global['mysqli']->query( $SQL );
				uss::console(':alert', $deleted ? "Question successfully deleted" : "Question not deleted" );
			};
		};
		
		$SQL = "
			SELECT 
				{$prefix}_questions.*,
					{$prefix}_subjects.name as subject
			FROM {$prefix}_questions
			LEFT JOIN {$prefix}_subjects
				ON {$prefix}_questions.subject_id = {$prefix}_subjects.id
			WHERE {$prefix}_questions.exam_id = {$exam['id']}
				ORDER BY {$prefix}_subjects.name ASC
		";
		
		$questions = uss::$global['mysqli']->query( $SQL );
		
	} else $questions = null;
	
	
	dashboard::view(function() use($exam, $questions) { ?>
	
		<div class='container-fluid'>
			<div class='row'>
				
				<?php if( empty($exam) ): ?>
					
					<div class='col-lg-8 col-10 m-auto'>
						<div class='my-5 text-center text-uppercase'>
							<h1 class='display-3 mb-4'>
								No Exam Data Found Here
							</h1>
							<a href='./' class='btn btn-secondary btn-lg w-100'>
								Go Back
							</a>
						</div>
					</div>
				
				<?php 
					else: 
						
						$table = new DOMTablet( 'questions' );
						$table->data( $questions );
						$table->columns(array(
							"index" => '',
							"subject",
							"question",
							"points",
							"image",
							"actions" => ''
						));
						$table->wrap();
						
						$href = explode("?", $_SERVER['REQUEST_URI'])[0];
						
				?>
					
					<div class='col-lg-12 mb-3'>
					
						<h2 class=''>
							<?php echo $exam['name']; ?>
						</h2> <hr>
						
						<div class='text-center text-sm-end'>
							<a href='question?exam=<?php echo $exam['id']; ?>' class='btn btn-primary'>
								<i class='bi bi-question me-1'></i> Add Question
							</a>
						</div>
						
					</div>
					
					<div class='col-lg-12'>
						<?php 
							$index = 0;
							$table->prepare(function($data) use(&$index, $exam) {
								$index++;
								$data['index'] = $index . ":";
								$size = 80;
								$data['question'] = strip_tags($data['question']);
								$data['question'] = substr_replace( substr($data['question'], 0, $size), '&hellip;<br>', (int)($size/2), 0 ) . ' &hellip;';
								$data['image'] = !empty($data['image']) ? 'Yes' : 'No';
								$data['actions'] = "
									<div class=''>
										<a href='question?exam={$exam['id']}&id={$data['id']}' class='btn btn-primary btn-sm mb-1'>
											<i class='bi bi-pencil'></i>
										</a>
										<a href='?id={$exam['id']}&delete={$data['id']}' class='btn btn-danger btn-sm mb-1' data-uss-confirm='Are you sure you want to delete this question'>
											<i class='bi bi-trash'></i>
										</a>
									</div>
								";
								return $data;
							}, true);
						?>
					</div>
					
				<?php endif; ?>
				
			</div>
		</div>
	
	<?php });
	
});