<?php 

// Set HREF Location;

$LOCATION =  PANEL_URI . '/exams';


// Set Page Menu;

$exam = uss::$global['menu']->add('exam', array(
	'label' => 'Exams',
	'icon' => '<i class="bi bi-bar-chart"></i>',
	'active' => preg_match("~{$LOCATION}~", $_GET['query'])
));

$exam->add('list', array(
	'label' => "View all",
	'href' => core::url( ROOT_DIR . "/{$LOCATION}" ),
))->set_attr('active', $_GET['query'] == $LOCATION);


// Create Page Exams;

uss::focus( $LOCATION, function() {
	
	$prefix = DB_TABLE_PREFIX;
	
	call_user_func(function() use($prefix) {
		if( isset($_GET['delete']) ) {
			$exam = dashboard::fetch_assoc( "{$prefix}_exams", $_GET['delete'] );
			if( !$exam ) return;
			$SQL = "DELETE FROM {$prefix}_exams WHERE id = {$exam['id']}";
			$status = uss::$global['mysqli']->query( $SQL );
			uss::console( ':alert', $status ? "Exam successfully deleted" : "The exam failed to delete" );
		};
	});
	
	$SQL = "
		SELECT 
			{$prefix}_exams.*,
				{$prefix}_departments.name as department
		FROM {$prefix}_exams
		LEFT JOIN {$prefix}_departments
		ON {$prefix}_exams.department_id = {$prefix}_departments.id
		WHERE 1 ORDER BY id DESC
	";
	
	$result = uss::$global['mysqli']->query( $SQL );
	
	// Make table ready;
	
	$table = new DOMTablet( 'exam' );
	$table->data( $result );
	
	$table->columns(array(
		"name",
		"portal" => "portal ID",
		"department",
		"questions",
		"start_date" => "Start Date",
		"exam_time" => "Time",
		"points",
		"action" => ''
	));
	
	$table->wrap();
	
	dashboard::view(function() use($table) { ?>
	
		<div class='container-fluid'>
			
			<div class='mb-4'>
				<div class='mb-2'>Registeration Link:</div>
				<div class='d-flex text-break'>
					<div class='border rounded-2 p-2 px-3 text-sm bg-light me-2'>
						<a href='<?php echo uss::$global['portal']; ?>' target='ctb-portal' id='text'>
							<?php echo uss::$global['portal']; ?>
						</a>
					</div>
					<div class=''>
						<button class='btn btn-info' data-uss-copy='#text'>
							<i class='bi bi-clipboard-plus'></i>
						</button>
					</div>
				</div>
			</div>
			
			<div class='row'>
			
				<div class='col-lg-12'>
					
					<?php 
						$table->prepare(function($data) {
							
							$prefix = DB_TABLE_PREFIX;
							
							$here = explode("?", $_SERVER['REQUEST_URI'])[0];

							if( substr($here, -1) == '/' ) $here = substr($here, 0, -1);
							
							$time = explode(".", $data['exam_time']);
							$data['exam_time'] = $time[0] . " Hr";
							if( !empty($time[1]) ) $data['exam_time'] .= " {$time[1]} Min";
							
							if( empty($data['department']) ) $data['department'] = "<i class='mdi mdi-alert-outline text-warning'></i>";
							
							$SQL = "
								SELECT 
									ROUND(SUM(points), 1) AS points,
									COUNT(exam_id) AS num_rows
								FROM {$prefix}_questions
								WHERE {$prefix}_questions.exam_id = {$data['id']}
								GROUP BY {$prefix}_questions.exam_id
							";
							
							$questions = uss::$global['mysqli']->query( $SQL )->fetch_assoc();
							
							$data['questions'] = $questions ? $questions['num_rows'] : 0;
							$data['points'] = $questions ? $questions['points'] : 0;
							
							$url = "{$here}/manager?id={$data['id']}";
							
							$data['portal'] = "<a href='javascript:void(0)' data-uss-copy='[data-portal=\"{$data['portal']}\"]' data-portal='{$data['portal']}' data-uss-message='Portal ID copied to clipboard'>{$data['portal']}</a>";
							
							$data['action'] = "
								<a href='{$url}' class='btn btn-success btn-sm mb-1'>
									<i class='bi bi-question-circle '></i> Questions
								</a>
								<a class='btn btn-primary btn-sm mb-1' href='exams/new?id={$data['id']}'>
									<i class='bi bi-pencil'></i>
								</a>
								<a href='exams?delete={$data['id']}' class='btn btn-danger btn-sm mb-1' data-uss-confirm='Are you sure you want to delete this exam? All examination questions will be lost as well'>
									<i class='bi bi-trash'></i>
								</a>
							";
							
							$icon = !empty($data['status']) ? 'fas fa-check-circle text-success' : 'fas fa-times-circle text-warning';
							
							$data['name'] = "
								<div class='d-flex'>
									<div class='me-2'><i class='{$icon}'></i></div>
									<div>{$data['name']}</div>
								</div>
							";
							
							$data['start_date'] = str_replace('T', ' ', $data['start_date']);
							
							return $data;
							
						}, true); 
					?>
					
				</div>
			
			</div>
		</div>
	
	<?php });
	
});